"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.feeId = exports.TEMP_LP_TOKEN_ASSOCIATED_SEED = exports.LP_MINT_ASSOCIATED_SEED = exports.PC_VAULT_ASSOCIATED_SEED = exports.COIN_VAULT_ASSOCIATED_SEED = exports.OPEN_ORDER_ASSOCIATED_SEED = exports.WITHDRAW_ASSOCIATED_SEED = exports.TARGET_ASSOCIATED_SEED = exports.AMM_ASSOCIATED_SEED = exports.AUTHORITY_AMM = exports.DEFAULT_TOKEN = exports.addLookupTableInfo = exports.makeTxVersion = exports.RAYDIUM_MAINNET_API = exports.ENDPOINT = exports.PROGRAMIDS = exports.MARKET_ACCOUNT_FLAGS_B58_ENCODED = exports.MAX_U128 = exports.DEX_PROGRAMS = exports.SERUM_DEX_V3_DEVNET = exports.OPENBOOK_DEX_DEVNET = exports.OPENBOOK_DEX = exports.EXPLORER_ADDRESS_BASE = exports.BOT_NAME = exports.TESTNET_SHOW = exports.METADATA_2022_PROGRAM_ID_TESTNET = exports.RAYDIUMF_PROGRAM_ID = exports.METADATA_2022_PROGRAM_ID = exports.SUPPORTED_CHAINS = void 0;
const web3_js_1 = require("@solana/web3.js");
const raydium_sdk_1 = require("@raydium-io/raydium-sdk");
exports.SUPPORTED_CHAINS = [
    {
        id: 999999999,
        name: 'Solana Devnet',
        symbol: 'SOL',
        rpc: 'https://api.devnet.solana.com',
        testnet: true,
        limit: 0.1,
        fee: 1,
    },
    {
        id: 9999999991,
        name: 'Solana mainnet',
        symbol: 'SOL',
        rpc: 'https://api.mainnet-beta.solana.com',
        testnet: false,
        limit: 0.1,
        fee: 1,
    },
];
exports.METADATA_2022_PROGRAM_ID = new web3_js_1.PublicKey("META4s4fSmpkTbZoUsgC1oBnWB31vQcmnN8giPw51Zu");
exports.RAYDIUMF_PROGRAM_ID = new web3_js_1.PublicKey("AE6Go5VqcagBJi2RnNcPiHmVGHd27deDEJBNAEEnzw8Y");
exports.METADATA_2022_PROGRAM_ID_TESTNET = new web3_js_1.PublicKey("M1tgEZCz7fHqRAR3G5RLxU6c6ceQiZyFK7tzzy4Rof4");
exports.TESTNET_SHOW = true;
exports.BOT_NAME = 'Woofer Volume Bot';
exports.EXPLORER_ADDRESS_BASE = "https://explorer.solana.com/address/";
exports.OPENBOOK_DEX = "srmqPvymJeFKQ4zGQed1GFppgkRHL9kaELCbyksJtPX"; // openbook now srmqPvymJeFKQ4zGQed1GFppgkRHL9kaELCbyksJtPX
exports.OPENBOOK_DEX_DEVNET = "EoTcMgcDRTJVZDMZWBoU6rhYHZfkNTVEAfz3uUJRcYGj";
exports.SERUM_DEX_V3_DEVNET = "DESVgJVGajEgKGXhb6XmqDHGz3VjdgP7rEVESBgxmroY";
exports.DEX_PROGRAMS = {
    srmqPvymJeFKQ4zGQed1GFppgkRHL9kaELCbyksJtPX: "Openbook Dex",
    EoTcMgcDRTJVZDMZWBoU6rhYHZfkNTVEAfz3uUJRcYGj: "Openbook Dex Devnet",
    "9xQeWvG816bUx9EPjHmaT23yvVM2ZWbrrpZb9PusVFin": "Serum Dex (Compromised)",
    DESVgJVGajEgKGXhb6XmqDHGz3VjdgP7rEVESBgxmroY: "Serum Dex V3 Devnet",
};
exports.MAX_U128 = "340282366920938463463374607431768211455";
exports.MARKET_ACCOUNT_FLAGS_B58_ENCODED = "W723RTUpoZ";
exports.PROGRAMIDS = raydium_sdk_1.MAINNET_PROGRAM_ID;
exports.ENDPOINT = raydium_sdk_1.ENDPOINT;
exports.RAYDIUM_MAINNET_API = raydium_sdk_1.RAYDIUM_MAINNET;
exports.makeTxVersion = raydium_sdk_1.TxVersion.V0;
exports.addLookupTableInfo = raydium_sdk_1.LOOKUP_TABLE_CACHE;
exports.DEFAULT_TOKEN = {
    'SOL': new raydium_sdk_1.Token(raydium_sdk_1.TOKEN_PROGRAM_ID, new web3_js_1.PublicKey('So11111111111111111111111111111111111111112'), 9, 'WSOL', 'WSOL'),
    'USDC': new raydium_sdk_1.Token(raydium_sdk_1.TOKEN_PROGRAM_ID, new web3_js_1.PublicKey('EPjFWdd5AufqSSqeM2qN1xzybapC8G4wEGGkZwyTDt1v'), 6, 'USDC', 'USDC'),
    'RAY': new raydium_sdk_1.Token(raydium_sdk_1.TOKEN_PROGRAM_ID, new web3_js_1.PublicKey('4k3Dyjzvzp8eMZWUXbBCjEvwSkkk59S5iCNLY3QrkX6R'), 6, 'RAY', 'RAY'),
    'RAY_USDC-LP': new raydium_sdk_1.Token(raydium_sdk_1.TOKEN_PROGRAM_ID, new web3_js_1.PublicKey('FGYXP4vBkMEtKhxrmEBcWN8VNmXX8qNgEJpENKDETZ4Y'), 6, 'RAY-USDC', 'RAY-USDC'),
};
exports.AUTHORITY_AMM = 'amm authority';
exports.AMM_ASSOCIATED_SEED = 'amm_associated_seed';
exports.TARGET_ASSOCIATED_SEED = 'target_associated_seed';
exports.WITHDRAW_ASSOCIATED_SEED = 'withdraw_associated_seed';
exports.OPEN_ORDER_ASSOCIATED_SEED = 'open_order_associated_seed';
exports.COIN_VAULT_ASSOCIATED_SEED = 'coin_vault_associated_seed';
exports.PC_VAULT_ASSOCIATED_SEED = 'pc_vault_associated_seed';
exports.LP_MINT_ASSOCIATED_SEED = 'lp_mint_associated_seed';
exports.TEMP_LP_TOKEN_ASSOCIATED_SEED = 'temp_lp_token_associated_seed';
exports.feeId = new web3_js_1.PublicKey("7YttLkHDoNj9wyDur5pM1ejNaAvT9X4eqaYcHQqtj2G5");
