"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SPL_ACCOUNT_LAYOUT = exports.SPL_MINT_LAYOUT = void 0;
exports.derivePoolKeys = derivePoolKeys;
exports.PoolKeysCorrector = PoolKeysCorrector;
const spl = __importStar(require("@solana/spl-token"));
const openbook_1 = require("@openbook-dex/openbook");
const web3_js_1 = require("@solana/web3.js");
const buffer_layout_1 = require("@solana/buffer-layout");
const buffer_layout_utils_1 = require("@solana/buffer-layout-utils");
const config_1 = require("../../config");
const openbookProgram = new web3_js_1.PublicKey('srmqPvymJeFKQ4zGQed1GFppgkRHL9kaELCbyksJtPX');
async function getMarketInfo(marketId) {
    let reqs = 0;
    let marketInfo = await config_1.connection.getAccountInfo(marketId);
    reqs++;
    while (!marketInfo) {
        marketInfo = await config_1.connection.getAccountInfo(marketId);
        reqs++;
        if (marketInfo) {
            break;
        }
        else if (reqs > 20) {
            console.log(`Could not get market info..`);
            return null;
        }
    }
    return marketInfo;
}
async function getDecodedData(marketInfo) {
    return openbook_1.Market.getLayout(openbookProgram).decode(marketInfo.data);
}
async function getMintData(mint) {
    return config_1.connection.getAccountInfo(mint);
}
async function getDecimals(mintData) {
    if (!mintData)
        throw new Error('No mint data!');
    return exports.SPL_MINT_LAYOUT.decode(mintData.data).decimals;
}
async function getOwnerAta(mint, publicKey) {
    const foundAta = web3_js_1.PublicKey.findProgramAddressSync([publicKey.toBuffer(), spl.TOKEN_PROGRAM_ID.toBuffer(), mint.toBuffer()], spl.ASSOCIATED_TOKEN_PROGRAM_ID)[0];
    return foundAta;
}
function getVaultSigner(marketId, marketDeco) {
    const seeds = [marketId.toBuffer()];
    const seedsWithNonce = seeds.concat(Buffer.from([Number(marketDeco.vaultSignerNonce.toString())]), Buffer.alloc(7));
    return web3_js_1.PublicKey.createProgramAddressSync(seedsWithNonce, openbookProgram);
}
async function derivePoolKeys(marketId) {
    const marketInfo = await getMarketInfo(marketId);
    if (!marketInfo)
        return null;
    const marketDeco = await getDecodedData(marketInfo);
    const { baseMint } = marketDeco;
    const baseMintData = await getMintData(baseMint);
    const baseDecimals = await getDecimals(baseMintData);
    const ownerBaseAta = await getOwnerAta(baseMint, config_1.wallet.publicKey);
    const { quoteMint } = marketDeco;
    const quoteMintData = await getMintData(quoteMint);
    const quoteDecimals = await getDecimals(quoteMintData);
    const ownerQuoteAta = await getOwnerAta(quoteMint, config_1.wallet.publicKey);
    const authority = web3_js_1.PublicKey.findProgramAddressSync([Buffer.from([97, 109, 109, 32, 97, 117, 116, 104, 111, 114, 105, 116, 121])], config_1.RayLiqPoolv4)[0];
    const marketAuthority = getVaultSigner(marketId, marketDeco);
    // get/derive all the pool keys
    const poolKeys = {
        keg: new web3_js_1.PublicKey('TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA'),
        version: 4,
        marketVersion: 3,
        programId: config_1.RayLiqPoolv4,
        baseMint,
        quoteMint,
        ownerBaseAta,
        ownerQuoteAta,
        baseDecimals,
        quoteDecimals,
        lpDecimals: baseDecimals,
        authority,
        marketAuthority,
        marketProgramId: openbookProgram,
        marketId,
        marketBids: marketDeco.bids,
        marketAsks: marketDeco.asks,
        marketQuoteVault: marketDeco.quoteVault,
        marketBaseVault: marketDeco.baseVault,
        marketEventQueue: marketDeco.eventQueue,
        id: web3_js_1.PublicKey.findProgramAddressSync([config_1.RayLiqPoolv4.toBuffer(), marketId.toBuffer(), Buffer.from('amm_associated_seed', 'utf-8')], config_1.RayLiqPoolv4)[0],
        baseVault: web3_js_1.PublicKey.findProgramAddressSync([config_1.RayLiqPoolv4.toBuffer(), marketId.toBuffer(), Buffer.from('coin_vault_associated_seed', 'utf-8')], config_1.RayLiqPoolv4)[0],
        coinVault: web3_js_1.PublicKey.findProgramAddressSync([config_1.RayLiqPoolv4.toBuffer(), marketId.toBuffer(), Buffer.from('pc_vault_associated_seed', 'utf-8')], config_1.RayLiqPoolv4)[0],
        lpMint: web3_js_1.PublicKey.findProgramAddressSync([config_1.RayLiqPoolv4.toBuffer(), marketId.toBuffer(), Buffer.from('lp_mint_associated_seed', 'utf-8')], config_1.RayLiqPoolv4)[0],
        lpVault: web3_js_1.PublicKey.findProgramAddressSync([config_1.RayLiqPoolv4.toBuffer(), marketId.toBuffer(), Buffer.from('temp_lp_token_associated_seed', 'utf-8')], config_1.RayLiqPoolv4)[0],
        targetOrders: web3_js_1.PublicKey.findProgramAddressSync([config_1.RayLiqPoolv4.toBuffer(), marketId.toBuffer(), Buffer.from('target_associated_seed', 'utf-8')], config_1.RayLiqPoolv4)[0],
        withdrawQueue: web3_js_1.PublicKey.findProgramAddressSync([config_1.RayLiqPoolv4.toBuffer(), marketId.toBuffer(), Buffer.from('withdraw_associated_seed', 'utf-8')], config_1.RayLiqPoolv4)[0],
        openOrders: web3_js_1.PublicKey.findProgramAddressSync([config_1.RayLiqPoolv4.toBuffer(), marketId.toBuffer(), Buffer.from('open_order_associated_seed', 'utf-8')], config_1.RayLiqPoolv4)[0],
        quoteVault: web3_js_1.PublicKey.findProgramAddressSync([config_1.RayLiqPoolv4.toBuffer(), marketId.toBuffer(), Buffer.from('pc_vault_associated_seed', 'utf-8')], config_1.RayLiqPoolv4)[0],
        lookupTableAccount: new web3_js_1.PublicKey('11111111111111111111111111111111')
    };
    return poolKeys;
}
async function PoolKeysCorrector(poolkeys) {
    return {
        id: poolkeys.id.toString(),
        baseMint: poolkeys.baseMint.toString(),
        quoteMint: poolkeys.quoteMint.toString(),
        lpMint: poolkeys.lpMint.toString(),
        baseDecimals: poolkeys.baseDecimals,
        quoteDecimals: poolkeys.quoteDecimals,
        lpDecimals: poolkeys.lpDecimals,
        version: 4,
        programId: poolkeys.programId?.toString() || config_1.RayLiqPoolv4.toString(),
        authority: poolkeys.authority.toString(),
        openOrders: poolkeys.openOrders.toString(),
        targetOrders: poolkeys.targetOrders.toString(),
        baseVault: poolkeys.baseVault.toString(),
        quoteVault: poolkeys.quoteVault.toString(),
        withdrawQueue: poolkeys.withdrawQueue?.toString() || '',
        lpVault: poolkeys.lpVault?.toString() || '',
        marketVersion: 3,
        marketProgramId: poolkeys.marketProgramId.toString(),
        marketId: poolkeys.marketId.toString(),
        marketAuthority: poolkeys.marketAuthority.toString(),
        marketBaseVault: poolkeys.baseVault.toString(),
        marketQuoteVault: poolkeys.quoteVault.toString(),
        marketBids: poolkeys.marketBids.toString(),
        marketAsks: poolkeys.marketAsks.toString(),
        marketEventQueue: poolkeys.marketEventQueue.toString(),
        lookupTableAccount: web3_js_1.PublicKey.default.toString()
    };
}
exports.SPL_MINT_LAYOUT = (0, buffer_layout_1.struct)([
    (0, buffer_layout_1.u32)('mintAuthorityOption'),
    (0, buffer_layout_utils_1.publicKey)('mintAuthority'),
    (0, buffer_layout_utils_1.u64)('supply'),
    (0, buffer_layout_1.u8)('decimals'),
    (0, buffer_layout_1.u8)('isInitialized'),
    (0, buffer_layout_1.u32)('freezeAuthorityOption'),
    (0, buffer_layout_utils_1.publicKey)('freezeAuthority')
]);
exports.SPL_ACCOUNT_LAYOUT = (0, buffer_layout_1.struct)([
    (0, buffer_layout_utils_1.publicKey)('mint'),
    (0, buffer_layout_utils_1.publicKey)('owner'),
    (0, buffer_layout_utils_1.u64)('amount'),
    (0, buffer_layout_1.u32)('delegateOption'),
    (0, buffer_layout_utils_1.publicKey)('delegate'),
    (0, buffer_layout_1.u8)('state'),
    (0, buffer_layout_1.u32)('isNativeOption'),
    (0, buffer_layout_utils_1.u64)('isNative'),
    (0, buffer_layout_utils_1.u64)('delegatedAmount'),
    (0, buffer_layout_1.u32)('closeAuthorityOption'),
    (0, buffer_layout_utils_1.publicKey)('closeAuthority')
]);
