@extends('themes.basic.workspace.layouts.app')
@section('title', translate('Referrals'))
@section('breadcrumbs', Breadcrumbs::render('workspace.referrals'))
@section('container', 'dashboard-container-lg')
@section('content')
    <div class="dashboard-card card-v mb-3">
        <h4 class="mb-3">{{ translate('Invite your friends and earn money!') }}</h4>
        <p class="mb-3 text-muted">
            {{ translate('Our referral program offers a great way to earn more income on the platform by just referring people who may purchase items. On each referral you have, you get :percentage% of their purchases.', ['percentage' => @$settings->referral->percentage]) }}
        </p>
        <div class="col-lg-6 mb-3">
            <div class="input-group">
                <input id="refLink" type="text" class="form-control form-control-md"
                    value="{{ authUser()->getReferralLink() }}" readonly>
                <button type="button" class="btn btn-primary btn-md btn-copy" id="input-group-button-right"
                    data-clipboard-target="#refLink">
                    <i class="far fa-clone"></i>
                    <span class="d-none d-lg-inline ms-2">
                        {{ translate('Copy') }}
                    </span>
                </button>
            </div>
        </div>
        @include('themes.basic.partials.share-buttons', [
            'link' => authUser()->getReferralLink(),
        ])
    </div>
    <div class="dashboard-card card-v p-0">
        @if ($referrals->count() > 0 || request()->input('search'))
            <div class="table-search p-4">
                <form action="{{ url()->current() }}" method="GET">
                    <div class="form-search">
                        <button class="icon">
                            <i class="fa fa-search"></i>
                        </button>
                        <input type="text" name="search" placeholder="{{ translate('Search...') }}"
                            class="form-control form-control-md" value="{{ request('search') }}">
                    </div>
                </form>
            </div>
            <div class="overflow-hidden">
                <div class="table-container">
                    <table class="dashboard-table table text-start table-borderless">
                        <thead>
                            <tr>
                                <th>{{ translate('Username') }}</th>
                                <th>{{ translate('Date') }}</th>
                                <th class="text-center">{{ translate('Earnings') }}</th>
                            </tr>
                        </thead>
                        <tbody class="text-muted">
                            @forelse ($referrals as $referral)
                                <tr>
                                    <td>{{ $referral->user->username }}</td>
                                    <td>{{ dateFormat($referral->created_at) }}</td>
                                    <td class="text-center">{{ getAmount($referral->earnings) }}</td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="3" class="text-center">
                                        <div class="text-muted p-4">{{ translate('No data found') }}</div>
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        @else
            <div class="dashboard-card-empty pd">
                <div class="py-4">
                    <div class="mb-3">
                        <svg xmlns="http://www.w3.org/2000/svg" width="200px" height="200px"
                            viewBox="0 0 717.67004 628.75122" xmlns:xlink="http://www.w3.org/1999/xlink">
                            <path
                                d="M619.55532,700.62905a2.80741,2.80741,0,0,1-2.03464-4.86593l.19237-.76476q-.038-.09188-.07644-.18358a7.53909,7.53909,0,0,0-13.90673.05167c-2.27452,5.4781-5.17037,10.96553-5.8834,16.75771a22.30336,22.30336,0,0,0,.39152,7.67061,89.41959,89.41959,0,0,1-8.13413-37.13874,86.307,86.307,0,0,1,.53535-9.6283q.4435-3.93126,1.23055-7.80653a90.45565,90.45565,0,0,1,17.93812-38.3373,24.07275,24.07275,0,0,0,10.01181-10.38735,18.36288,18.36288,0,0,0,1.67-5.0179c-.48739.06393-1.83779-7.3591-1.47018-7.81452-.67924-1.03072-1.895-1.54307-2.6368-2.54886-3.68944-5.0021-8.77254-4.12871-11.42613,2.66876-5.66869,2.861-5.72357,7.60577-2.24528,12.16916,2.2129,2.90325,2.517,6.83168,4.45862,9.93984-.1998.25572-.40756.50344-.6073.75916a91.03942,91.03942,0,0,0-9.50222,15.05379,37.84618,37.84618,0,0,0-2.25945-17.57871c-2.16269-5.21725-6.21633-9.61122-9.786-14.12153-4.2878-5.41757-13.08033-3.05323-13.83575,3.81439q-.011.09974-.02141.19941.79531.44867,1.55706.95247a3.80805,3.80805,0,0,1-1.53533,6.92993l-.07765.012a37.89124,37.89124,0,0,0,.99876,5.66516c-4.57949,17.71008,5.30731,24.16046,19.42432,24.45023.31164.15978.61531.31957.927.47144A92.92416,92.92416,0,0,0,588.44992,675.54a88.1355,88.1355,0,0,0,.06393,14.23066l-.024-.16778a23.28922,23.28922,0,0,0-7.95036-13.44764c-6.11821-5.02589-14.76211-6.87666-21.36259-10.9165a4.37073,4.37073,0,0,0-6.69422,4.252q.01327.0882.027.17642a25.57893,25.57893,0,0,1,2.86848,1.38226q.79533.44877,1.55706.95246a3.8081,3.8081,0,0,1-1.53533,6.93l-.07771.01193c-.05592.008-.10388.016-.15973.02405a37.92279,37.92279,0,0,0,6.97545,10.92264c2.86344,15.46022,15.162,16.927,28.31753,12.42488h.008a92.89674,92.89674,0,0,0,6.24044,18.21781h22.29279c.08-.24769.15185-.5034.22379-.75113a25.32893,25.32893,0,0,1-6.16855-.36745c1.654-2.02957,3.308-4.07513,4.962-6.10463a1.38254,1.38254,0,0,0,.10388-.11987c.839-1.03866,1.68595-2.06945,2.52491-3.10816l.00045-.00126a37.1011,37.1011,0,0,0-1.08711-9.45126Z"
                                transform="translate(-228.12561 -94.1362)" fill="#f2f2f2" />
                            <path
                                d="M586.52618,348.1362a127,127,0,1,1,127-127A127.1441,127.1441,0,0,1,586.52618,348.1362Zm0-252a125,125,0,1,0,125,125A125.1415,125.1415,0,0,0,586.52618,96.1362Z"
                                transform="translate(-228.12561 -94.1362)" fill="#f2f2f2" />
                            <path d="M600.46063,267.1362h-27a5,5,0,0,1,0-10h27a5,5,0,0,1,0,10Z"
                                transform="translate(-228.12561 -94.1362)" fill="#e6e6e6" />
                            <path
                                d="M606.66333,412.25329h-39.4054a7.2973,7.2973,0,1,1,0-14.5946h39.4054a7.2973,7.2973,0,1,1,0,14.5946Z"
                                transform="translate(-228.12561 -94.1362)"
                                fill="{{ $themeSettings->colors->primary_color }}" />
                            <path
                                d="M718.673,381.66649H455.24823a8.86341,8.86341,0,0,1-8.85315-8.85315V294.27885a8.86341,8.86341,0,0,1,8.85315-8.85315H718.673a8.86341,8.86341,0,0,1,8.85315,8.85315v78.53449A8.86341,8.86341,0,0,1,718.673,381.66649Z"
                                transform="translate(-228.12561 -94.1362)" fill="#e6e6e6" />
                            <path
                                d="M693.07807,375.69492H461.22123a8.86341,8.86341,0,0,1-8.85316-8.85315V300.25518a8.86341,8.86341,0,0,1,8.85316-8.85315H712.70146a8.86341,8.86341,0,0,1,8.85315,8.85315v46.9632A28.50863,28.50863,0,0,1,693.07807,375.69492Z"
                                transform="translate(-228.12561 -94.1362)" fill="#fff" />
                            <path
                                d="M613.10089,315.08347H507.22421a2.28323,2.28323,0,1,1,0-4.56646H613.10089a2.28323,2.28323,0,0,1,0,4.56646Z"
                                transform="translate(-228.12561 -94.1362)"
                                fill="{{ $themeSettings->colors->primary_color }}" />
                            <path
                                d="M666.69752,324.422H507.22421a2.28323,2.28323,0,1,1,0-4.56646H666.69752a2.28323,2.28323,0,0,1,0,4.56646Z"
                                transform="translate(-228.12561 -94.1362)" fill="#e6e6e6" />
                            <path
                                d="M666.69752,335.14129H507.22421a2.28324,2.28324,0,1,1,0-4.56647H666.69752a2.28324,2.28324,0,0,1,0,4.56647Z"
                                transform="translate(-228.12561 -94.1362)" fill="#e6e6e6" />
                            <path
                                d="M666.69752,345.86062H507.22421a2.28324,2.28324,0,1,1,0-4.56647H666.69752a2.28324,2.28324,0,0,1,0,4.56647Z"
                                transform="translate(-228.12561 -94.1362)" fill="#e6e6e6" />
                            <path
                                d="M666.69752,356.58H507.22421a2.28324,2.28324,0,1,1,0-4.56647H666.69752a2.28324,2.28324,0,0,1,0,4.56647Z"
                                transform="translate(-228.12561 -94.1362)" fill="#e6e6e6" />
                            <polygon
                                points="578.689 615.836 567.988 615.835 562.897 574.558 578.692 574.559 578.689 615.836"
                                fill="#a0616a" />
                            <path
                                d="M807.19178,721.1362l-32.90852-.00125v-.41614a12.80963,12.80963,0,0,1,12.80892-12.80871h.00079l6.01114-4.56034,11.21549,4.56107,2.87271.00006Z"
                                transform="translate(-228.12561 -94.1362)" fill="#2f2e41" />
                            <polygon points="666.179 602.133 656.59 606.883 633.703 572.157 647.856 565.146 666.179 602.133"
                                fill="#a0616a" />
                            <path
                                d="M899.59878,706.10556l-29.48815,14.60889-.18475-.37288a12.80961,12.80961,0,0,1,5.79086-17.16384l.00071-.00035,3.36167-6.755,12.07453-.89227,2.57411-1.27531Z"
                                transform="translate(-228.12561 -94.1362)" fill="#2f2e41" />
                            <path
                                d="M775.11234,488.10038s-12.18149,16.9818-3.38863,46.32048,3.85671,55.56833,6.32478,60.82787,7.43648,10.25444,3.331,14.24206-6.26716,7.23016-3.02463,8.311,14.051,76.74,14.051,76.74l18.37437,1.08084s6.65632-35.14578-.4548-63.50881c0,0,1.56108-20.59025-1.69417-26.63833s-2.617-.59279-2.39569-8.18424a66.65571,66.65571,0,0,1,2.383-16.23821c1.08084-4.32338,1.70689-47.89761,1.70689-47.89761l17.8871,57.82431a14.39855,14.39855,0,0,1,.78881,6.22643c-.44252,2.97871-.44639,7.42975.096,8.98718s1.14636,1.88494.84436,4.96373,35.698,67.9791,35.698,67.9791l17.88651-12-17.62285-56.90032a26.75277,26.75277,0,0,1-4.32338-6.48507c-2.16169-4.32338-2.24586-4.56167-1.12293-7.68506S861.58,586.85729,861.58,585.036s1.12292-84.50273-12.9491-96.66383S775.11234,488.10038,775.11234,488.10038Z"
                                transform="translate(-228.12561 -94.1362)" fill="#2f2e41" />
                            <path
                                d="M841.18828,356.55923l-3.6621-10.423-10-10L809.08087,333.934l-12.00815,7.89466-11.12134,10.96375L769.52618,489.1362s77.58268,29.91167,87.748,4.80908Z"
                                transform="translate(-228.12561 -94.1362)" fill="#ccc" />
                            <path
                                d="M847.47745,356.55923l-10.77612-10.77612s-5.14759,68.87183-2.95467,73.71571,4.77559,3.60765,1.98425,6.22576-5.79134.01969-2.79134,4.8189a15.19078,15.19078,0,0,1,2.47687,9.08969s15.52313,97.70952,24.52313,97.70952,14.63456-2.63455,14.31728-5.31728-5.62623-9.36228-3.97176-11.0225,5.73289-.40641,1.69369-3.53331-6.03921-2.12691-5.03921-6.12691-6.6451-55.85433-6.6451-55.85433l-.74554-86.61354Z"
                                transform="translate(-228.12561 -94.1362)" fill="#3f3d56" />
                            <path
                                d="M797.07272,341.82868l-13.956,1.97464-16.59056,6.33288s7.57759,85.48208,5.99549,88.34429-4.39312,1.0748-1.98761,3.9685,4.56971,1.61024,1.98761,4.252-6.92856-.70472-4.25533,3.9685-10.20866,69.01535-6.74016,72.46674,12.40552,1.3037,12.40945-1.2449a14.75932,14.75932,0,0,0-2.99606-7.54861,3.04167,3.04167,0,0,1,0-4,9.778,9.778,0,0,0,2.79278-5.0458c.20722-1.9542,1.73478-4.35577,2.471-6.155s19.27872-123.59056,19.27872-123.59056Z"
                                transform="translate(-228.12561 -94.1362)" fill="#3f3d56" />
                            <path
                                d="M737.52618,409.1362l6.294-3.28634C735.9615,398.7616,716.4632,387.164,716.4632,387.164l-33.6065-22.6564a7.16306,7.16306,0,1,0-7.44111,9.91334l37.6615,33.74105Z"
                                transform="translate(-228.12561 -94.1362)" fill="#a0616a" />
                            <path
                                d="M783.52618,384.1362l.06834-27.634-15.35121-7.34179L729.52618,390.1362l-3-2h-7l-17,20s9.0543,5.36572,13.52715,3.18286,4.05262.95356,4.05262.95356a4.74282,4.74282,0,0,0,5.71947,1.34576c3.70076-1.48218,10.70076,2.51782,10.70076,2.51782Z"
                                transform="translate(-228.12561 -94.1362)" fill="#3f3d56" />
                            <circle cx="592.19409" cy="211.06344" r="22.38635" fill="#a0616a" />
                            <path
                                d="M847.34385,310.88332a38.93025,38.93025,0,0,1-8.375,10.99715,8.68328,8.68328,0,0,1-3.64322,2.45662,3.17433,3.17433,0,0,1-3.77537-1.50709l-.41479-.56691a11.55349,11.55349,0,0,0,3.35117-1.65745,3.93438,3.93438,0,0,0,1.62106-3.214,2.42256,2.42256,0,0,0-2.46849-2.281c-1.3984.16634-2.64822,1.79936-3.90126,1.16989-1.01213-.51452-.86706-1.98783-.57657-3.10013,1.55768-5.805.90591-14.8029-1.33612-15.11744a18.13267,18.13267,0,0,1-6.26153-2.56285,17.56941,17.56941,0,0,0-6.28155-2.52642c-.16119-.02123-.325-.03271-.49847-.04678a14.87168,14.87168,0,0,0-.621-3.52858,17.40077,17.40077,0,0,1-1.10822,3.52514,34.518,34.518,0,0,1-5.85129.2958c-2.08383-.24191-8.07331,4.614-8.1177,3.94584a14.87118,14.87118,0,0,0-.621-3.52858,17.40077,17.40077,0,0,1-1.10822,3.52514c-.0225.04622-.0327.08529-.05521.13151-.63679-1.5525-.81915-3.28854-.80341-1.99207-1.3371-8.24931,1.3149-13.21607,8.08506-18.1079a10.21887,10.21887,0,0,1,4.6617-2.0865,5.023,5.023,0,0,1,4.61959,1.70676,16.489,16.489,0,0,1,16.70735.75709c4.86985,3.26251,8.71168,5.43314,8.06352,11.26717,4.61571.44455,8.51476,4.15181,9.973,8.54523C850.05384,301.78362,849.30289,306.69444,847.34385,310.88332Z"
                                transform="translate(-228.12561 -94.1362)" fill="#2f2e41" />
                            <path
                                d="M875.91875,427.53185l-16.0607-2.30042c-5.43182,9.08278-7.3621,33.25826-7.3621,33.25826L836.77807,495.8482a7.16306,7.16306,0,1,0,11.16691,5.38l25.80717-43.48375Z"
                                transform="translate(-228.12561 -94.1362)" fill="#a0616a" />
                            <path
                                d="M838.939,371.84055l6.80542-9.37334,13.79961,6.41285,11.47739,44.27276s8.38147,5.45444,6.5935,9.30193-2.73878,6.95224-.89037,9.15684,7.23112,2.36682,3.22141,5.96156-.5772,12.98718-.5772,12.98718l-3.84253,8.57587-24-1Z"
                                transform="translate(-228.12561 -94.1362)" fill="#3f3d56" />
                            <path
                                d="M283.86378,509.15137a7.39194,7.39194,0,0,0,1.375-10.21805,7.09127,7.09127,0,0,0-.78742-.86851l10.24808-23.66446-10.17824-9.42491-10.53377,33.93517a7.37146,7.37146,0,0,0-.15963,8.998,7.05444,7.05444,0,0,0,9.88312,1.36188Q283.78819,509.212,283.86378,509.15137Z"
                                transform="translate(-228.12561 -94.1362)" fill="#ffb6b6" />
                            <path
                                d="M343.401,355.63643s-7.586-14.42135-25.18388,1.15266S279.824,450.31821,280.22784,453.2489s4.70512,1.77151-.73535,5.99107-8.44858.42836-5.44048,4.21955,9.735,7.8076,3.77882,8.3714,15.87859,9.95788,15.87859,9.95788,3.43439-.82458,4.48807-8.749c.59181-4.45079-1.41359-6.97825,2.11657-7.71992s.22123-8.79069.7294-10.05731,28.6955-56.58079,28.6955-56.58079Z"
                                transform="translate(-228.12561 -94.1362)"
                                fill="{{ $themeSettings->colors->primary_color }}" />
                            <polygon
                                points="149.919 613.706 162.661 613.705 168.724 564.551 149.916 564.552 149.919 613.706"
                                fill="#ffb6b6" />
                            <path
                                d="M377.595,721.1362l39.188-.00147v-.4956A15.25392,15.25392,0,0,0,401.53,705.38629H401.529l-7.1582-5.43058-13.35561,5.43141-3.42086.00012Z"
                                transform="translate(-228.12561 -94.1362)" fill="#2f2e41" />
                            <polygon points="60.597 590.265 71.021 597.594 104.255 560.873 88.868 550.055 60.597 590.265"
                                fill="#ffb6b6" />
                            <path
                                d="M280.70865,695.01757l32.05709,22.53986.28507-.4054a15.25392,15.25392,0,0,0-3.70371-21.2506l-.00077-.00054-2.7318-8.55969-14.0492-3.23924-2.79836-1.96759Z"
                                transform="translate(-228.12561 -94.1362)" fill="#2f2e41" />
                            <path
                                d="M327.2705,463.30179l-1.05883,2.26205c-6.96012,14.86935-8.73972,31.49118-6.03494,47.68454a2.70118,2.70118,0,0,1-.10788,1.92133c-1.67744,1.9675.95432,10.51556,2.46286,15.28855l1.35967,8.44037s-2.25459,7.8389,1.17,7.2628-1.675,7.78528,1.5916,9.88l8.4739,52.60292-35.35359,58.268,13.09393,18.98619,52.37568-67.4337.6547-60.88673,7.85635,49.1022.6547,77.25414,23.82107-2.5322,8.72751-74.89888-8.32483-103.58207-13.09392-44.91113Z"
                                transform="translate(-228.12561 -94.1362)" fill="#2f2e41" />
                            <path
                                d="M343.63719,328.44584l19.27131.91768,9.21545,15.92032h0a28.49122,28.49122,0,0,1,18.223,16.59995l6.00079,14.82546-6.82646,85.71807s-1.36832,5.18464,1.1512,4.42768,1.49256,5.7406,1.49256,5.7406l9.2861,35.71578-84.42668-7.34145,4.68792-37.8408s-6.51775.21033-1.93488-4.37254,6.8116-3.123,2.40915-8.541-5.05714-9.34617-5.05714-9.34617l-1.96409-26.84254-3.238-37.77669a36.29859,36.29859,0,0,1,13.71312-31.62109l0,0Z"
                                transform="translate(-228.12561 -94.1362)"
                                fill="{{ $themeSettings->colors->primary_color }}" />
                            <circle cx="125.50492" cy="205.44964" r="24.43944" fill="#ffb6b6" />
                            <path
                                d="M344.18717,322.02207c7.0132-.2301,7.65028-2.08255,14.66347-2.31265,2.23308-.07326,4.8682-.37933,5.94781-2.33545a5.15426,5.15426,0,0,0-.26162-4.58788,41.90061,41.90061,0,0,1-2.1605-4.25,7.423,7.423,0,0,1,7.35488-9.78646c2.13422.09222,4.1386,1.09586,6.26692,1.27929,2.91886.25157,9.3732-9.38574,8.02934-11.989-1.30811-2.534-3.94066-4.44589-4.35443-7.26748-.27062-1.84544.49115-3.6791.59524-5.54137.15434-2.76125-6.8451,3.46477-5.56323,1.01423,3.14449-6.01131-26.48723-13.46375-31.3656-5.934-1.82323,2.81417-5.07254,2.62222-7.96866,4.3123-1.89816,1.1077-6.6912,4.92918-7.78084,7.31106a18.54471,18.54471,0,0,0-1.388,7.67312c-.04384,12.21824,1.81761,23.45714,11.67292,30.67934"
                                transform="translate(-228.12561 -94.1362)" fill="#2f2e41" />
                            <path
                                d="M413.56784,508.101a7.392,7.392,0,0,1-.76264-10.28191,7.09158,7.09158,0,0,1,.83787-.82l-8.81716-24.234,10.7227-8.80051,8.48923,34.50346a7.37145,7.37145,0,0,1-.37779,8.99149,7.05445,7.05445,0,0,1-9.94679.76949Q413.63969,508.166,413.56784,508.101Z"
                                transform="translate(-228.12561 -94.1362)" fill="#ffb6b6" />
                            <path
                                d="M363.30078,351.30576s8.43333-13.9428,25.07017,2.65394,32.7415,95.65419,32.16342,98.55555-4.80248,1.48749.37641,6.02428,8.40793.93193,5.17889,4.53679-10.18369,7.21256-4.27181,8.1309-16.44471,8.99226-16.44471,8.99226-3.379-1.02813-3.95779-9.00127c-.32507-4.47819,1.82763-6.88143-1.652-7.83251s.30392-8.78822-.12773-10.08291-25.26676-58.19286-25.26676-58.19286Z"
                                transform="translate(-228.12561 -94.1362)"
                                fill="{{ $themeSettings->colors->primary_color }}" />
                            <path
                                d="M606.47607,218.40679a20.005,20.005,0,1,1-20.01-20A19.98329,19.98329,0,0,1,606.47607,218.40679Z"
                                transform="translate(-228.12561 -94.1362)"
                                fill="{{ $themeSettings->colors->primary_color }}" />
                            <circle cx="358.7866" cy="120.16971" r="7" fill="#fff" />
                            <path
                                d="M594.41607,223.80675h-15a3.50386,3.50386,0,0,0-3.5,3.5,52.9601,52.9601,0,0,0,1.4,8.89,19.98582,19.98582,0,0,0,19.34-.57,52.45736,52.45736,0,0,0,1.26-8.32A3.50385,3.50385,0,0,0,594.41607,223.80675Z"
                                transform="translate(-228.12561 -94.1362)" fill="#fff" />
                            <path
                                d="M228.12561,721.69742a1.18647,1.18647,0,0,0,1.19006,1.19h715.29a1.19,1.19,0,0,0,0-2.38h-715.29A1.18651,1.18651,0,0,0,228.12561,721.69742Z"
                                transform="translate(-228.12561 -94.1362)" fill="#ccc" />
                        </svg>
                    </div>
                    <h4>{{ translate('You do not have any referrals') }}</h4>
                    <p class="mb-0">
                        {{ translate('Share your referral link with your friends or via social media so that your referrals appear here.') }}
                    </p>
                </div>
            </div>
        @endif
    </div>
    {{ $referrals->links() }}
    @push('scripts_libs')
        <script src="{{ asset('vendor/libs/clipboard/clipboard.min.js') }}"></script>
    @endpush
@endsection
