<?php
return [
    'accepted' => translate('The :attribute field must be accepted.'),
    'accepted_if' => translate('The :attribute field must be accepted when :other is :value.'),
    'active_url' => translate('The :attribute field must be a valid URL.'),
    'after' => translate('The :attribute field must be a date after :date.'),
    'after_or_equal' => translate('The :attribute field must be a date after or equal to :date.'),
    'alpha' => translate('The :attribute field must only contain letters.'),
    'alpha_dash' => translate('The :attribute field must only contain letters, numbers, dashes, and underscores.'),
    'alpha_num' => translate('The :attribute field must only contain letters and numbers.'),
    'array' => translate('The :attribute field must be an array.'),
    'ascii' => translate('The :attribute field must only contain single-byte alphanumeric characters and symbols.'),
    'before' => translate('The :attribute field must be a date before :date.'),
    'before_or_equal' => translate('The :attribute field must be a date before or equal to :date.'),
    'between' => [
        'array' => translate('The :attribute field must have between :min and :max items.'),
        'file' => translate('The :attribute field must be between :min and :max kilobytes.'),
        'numeric' => translate('The :attribute field must be between :min and :max.'),
        'string' => translate('The :attribute field must be between :min and :max characters.'),
    ],
    'boolean' => translate('The :attribute field must be true or false.'),
    'can' => translate('The :attribute field contains an unauthorized value.'),
    'confirmed' => translate('The :attribute field confirmation does not match.'),
    'current_password' => translate('The password is incorrect.'),
    'date' => translate('The :attribute field must be a valid date.'),
    'date_equals' => translate('The :attribute field must be a date equal to :date.'),
    'date_format' => translate('The :attribute field must match the format :format.'),
    'decimal' => translate('The :attribute field must have :decimal decimal places.'),
    'declined' => translate('The :attribute field must be declined.'),
    'declined_if' => translate('The :attribute field must be declined when :other is :value.'),
    'different' => translate('The :attribute field and :other must be different.'),
    'digits' => translate('The :attribute field must be :digits digits.'),
    'digits_between' => translate('The :attribute field must be between :min and :max digits.'),
    'dimensions' => translate('The :attribute field has invalid image dimensions.'),
    'distinct' => translate('The :attribute field has a duplicate value.'),
    'doesnt_end_with' => translate('The :attribute field must not end with one of the following: :values.'),
    'doesnt_start_with' => translate('The :attribute field must not start with one of the following: :values.'),
    'email' => translate('The :attribute field must be a valid email address.'),
    'username' => translate('The :attribute field must be a valid username.'),
    'ends_with' => translate('The :attribute field must end with one of the following: :values.'),
    'enum' => translate('The selected :attribute is invalid.'),
    'exists' => translate('The selected :attribute is invalid.'),
    'file' => translate('The :attribute field must be a file.'),
    'filled' => translate('The :attribute field must have a value.'),
    'gt' => [
        'array' => translate('The :attribute field must have more than :value items.'),
        'file' => translate('The :attribute field must be greater than :value kilobytes.'),
        'numeric' => translate('The :attribute field must be greater than :value.'),
        'string' => translate('The :attribute field must be greater than :value characters.'),
    ],
    'gte' => [
        'array' => translate('The :attribute field must have :value items or more.'),
        'file' => translate('The :attribute field must be greater than or equal to :value kilobytes.'),
        'numeric' => translate('The :attribute field must be greater than or equal to :value.'),
        'string' => translate('The :attribute field must be greater than or equal to :value characters.'),
    ],
    'image' => translate('The :attribute field must be an image.'),
    'in' => translate('The selected :attribute is invalid.'),
    'in_array' => translate('The :attribute field must exist in :other.'),
    'integer' => translate('The :attribute field must be an integer.'),
    'ip' => translate('The :attribute field must be a valid IP address.'),
    'ipv4' => translate('The :attribute field must be a valid IPv4 address.'),
    'ipv6' => translate('The :attribute field must be a valid IPv6 address.'),
    'json' => translate('The :attribute field must be a valid JSON string.'),
    'lowercase' => translate('The :attribute field must be lowercase.'),
    'lt' => [
        'array' => translate('The :attribute field must have less than :value items.'),
        'file' => translate('The :attribute field must be less than :value kilobytes.'),
        'numeric' => translate('The :attribute field must be less than :value.'),
        'string' => translate('The :attribute field must be less than :value characters.'),
    ],
    'lte' => [
        'array' => translate('The :attribute field must not have more than :value items.'),
        'file' => translate('The :attribute field must be less than or equal to :value kilobytes.'),
        'numeric' => translate('The :attribute field must be less than or equal to :value.'),
        'string' => translate('The :attribute field must be less than or equal to :value characters.'),
    ],
    'mac_address' => translate('The :attribute field must be a valid MAC address.'),
    'max' => [
        'array' => translate('The :attribute field must not have more than :max items.'),
        'file' => translate('The :attribute field must not be greater than :max kilobytes.'),
        'numeric' => translate('The :attribute field must not be greater than :max.'),
        'string' => translate('The :attribute field must not be greater than :max characters.'),
    ],
    'max_digits' => translate('The :attribute field must not have more than :max digits.'),
    'mimes' => translate('The :attribute field must be a file of type: :values.'),
    'mimetypes' => translate('The :attribute field must be a file of type: :values.'),
    'min' => [
        'array' => translate('The :attribute field must have at least :min items.'),
        'file' => translate('The :attribute field must be at least :min kilobytes.'),
        'numeric' => translate('The :attribute field must be at least :min.'),
        'string' => translate('The :attribute field must be at least :min characters.'),
    ],
    'min_digits' => translate('The :attribute field must have at least :min digits.'),
    'missing' => translate('The :attribute field must be missing.'),
    'missing_if' => translate('The :attribute field must be missing when :other is :value.'),
    'missing_unless' => translate('The :attribute field must be missing unless :other is :value.'),
    'missing_with' => translate('The :attribute field must be missing when :values is present.'),
    'missing_with_all' => translate('The :attribute field must be missing when :values are present.'),
    'multiple_of' => translate('The :attribute field must be a multiple of :value.'),
    'not_in' => translate('The selected :attribute is invalid.'),
    'not_regex' => translate('The :attribute field format is invalid.'),
    'numeric' => translate('The :attribute field must be a number.'),
    'password' => [
        'letters' => translate('The :attribute field must contain at least one letter.'),
        'mixed' => translate('The :attribute field must contain at least one uppercase and one lowercase letter.'),
        'numbers' => translate('The :attribute field must contain at least one number.'),
        'symbols' => translate('The :attribute field must contain at least one symbol.'),
        'uncompromised' => translate('The given :attribute has appeared in a data leak. Please choose a different :attribute.'),
    ],
    'present' => translate('The :attribute field must be present.'),
    'prohibited' => translate('The :attribute field is prohibited.'),
    'prohibited_if' => translate('The :attribute field is prohibited when :other is :value.'),
    'prohibited_unless' => translate('The :attribute field is prohibited unless :other is in :values.'),
    'prohibits' => translate('The :attribute field prohibits :other from being present.'),
    'regex' => translate('The :attribute field format is invalid.'),
    'required' => translate('The :attribute field is required.'),
    'required_array_keys' => translate('The :attribute field must contain entries for: :values.'),
    'required_if' => translate('The :attribute field is required when :other is :value.'),
    'required_if_accepted' => translate('The :attribute field is required when :other is accepted.'),
    'required_unless' => translate('The :attribute field is required unless :other is in :values.'),
    'required_with' => translate('The :attribute field is required when :values is present.'),
    'required_with_all' => translate('The :attribute field is required when :values are present.'),
    'required_without' => translate('The :attribute field is required when :values is not present.'),
    'required_without_all' => translate('The :attribute field is required when none of :values are present.'),
    'same' => translate('The :attribute field must match :other.'),
    'size' => [
        'array' => translate('The :attribute field must contain :size items.'),
        'file' => translate('The :attribute field must be :size kilobytes.'),
        'numeric' => translate('The :attribute field must be :size.'),
        'string' => translate('The :attribute field must be :size characters.'),
    ],
    'starts_with' => translate('The :attribute field must start with one of the following: :values.'),
    'string' => translate('The :attribute field must be a string.'),
    'timezone' => translate('The :attribute field must be a valid timezone.'),
    'unique' => translate('The :attribute has already been taken.'),
    'uploaded' => translate('The :attribute failed to upload.'),
    'uppercase' => translate('The :attribute field must be uppercase.'),
    'url' => translate('The :attribute field must be a valid URL.'),
    'ulid' => translate('The :attribute field must be a valid ULID.'),
    'uuid' => translate('The :attribute field must be a valid UUID.'),
    'captcha' => translate('Captcha verification failed.'),
    'attributes' => [
        'captcha' => translate('captcha'),
        'terms' => translate('terms of service'),
    ],
    'phone_number' => translate('Phone number must be a valid 10-digit phone number.'),
    'block_patterns' => translate('The :attribute contains blocked patterns.'),
    'indisposable' => translate('The email type are not allowed.'),
];
